//Aim:To design m-derived T and pi section high-pass filter.
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
f_infinity=3.6*(10^3);//Frequency at infinite attenuation.
fc=4*(10^3);//Cut-off frequency.
R0=600;//Nominal characteristic impedance.

//Computing the values of m:
m=sqrt(1-((f_infinity/fc)^2));
disp(m,'m=')
C=1/(4*%pi*fc*R0);//C is the series arm capacitance.
disp('Farads',C,'C=')
L=R0/(4*%pi*fc);//L is the shunt arm inductance.
disp('Henry',L,'L=')

//Computation of the values of the circuit elements for T-section 
//of m-derived filter :
a=(2*C)/m;
disp('Farads',a,'2C/m=')
b=L/m;
disp('Henry',b,'L/m=')
c=((4*m)/(1-(m^2)))*C;
disp('Farads',c,'((4*m)/(1-(m^2)))*C=')
//Computation of the values of the circuit elements for pi-section 
//of m-derived filter :
d=(2*L)/m;
disp('Henry',d,'2L/m=')
e=C/m;
disp('Farads',e,'C/m=')
f=((4*m)/(1-(m^2)))*L;
disp('Henry',f,'((4*m)/(1-(m^2)))*L=')
